/*!
 * @file        usb_user.c
 *
 * @brief       usb user configuration
 *
 * @version     V1.0.0
 *
 * @date        2022-05-25
 *
 */
#include "usb_user.h"


static void USB_USER_DeviceReset(void);
static void USB_USER_DeviceSuspend(void);
static void USB_USER_DeviceResume(void);
#if (DELAY_SOURCE != USE_DEFAULT)
static void USB_USER_Delay(uint32_t cnt);
#endif

USB_UserCallBack_T g_userCallback =
{
    USB_USER_DeviceReset,
    USB_USER_DeviceSuspend,
    USB_USER_DeviceResume,
#if (DELAY_SOURCE == USE_DEFAULT)
    NULL
#else
    USB_USER_Delay
#endif
};

static void USB_USER_DeviceReset(void)
{
}

static void USB_USER_DeviceSuspend(void)
{
}

static void USB_USER_DeviceResume(void)
{
}

#if (DELAY_SOURCE != USE_DEFAULT)
static void USB_USER_Delay(uint32_t cnt)
{
    __IO uint32_t i = 0;
    __IO uint32_t j = 0;
    __IO uint32_t delayCnt;

    delayCnt = (cnt*6);

    do
    {
        i++;
        j++;
    }
    while (i < cnt);
}
#endif
